<?php
/*--------------------------------------------------------------
   Deleted.php 2021-05-27
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Model\Events;

use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Id;

class Deleted
{
    /**
     * @var Id
     */
    private $id;
    
    
    /**
     * Constructor.
     */
    private function __construct(Id $id)
    {
        $this->id = $id;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Id $id): self
    {
        return new self($id);
    }
    
    
    /**
     * Return ID.
     */
    public function id(): Id
    {
        return $this->id;
    }
}